/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.manageconns;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.manageconns.RcsConnectionsConstants;
import com.ibm.hwmca.fw.rcs.manageconns.RcsPathInfo;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.impl.RawRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DateItemDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TimeItemDescriptor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class RcsConnectionsBean
extends PanelBean
implements RcsConnectionsConstants {
    private static final String TRACE_MASKT = "XRCSCNBT";
    private static final String TRACE_MASKF = "XRCSCNBF";
    private static final String TRACE_MASKD = "XRCSCNBD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-ConnBean");
    private String taskletRequestId = this.toString();
    private int taskletRequestNum = 0;
    private boolean queueEnabled = true;
    private List activeReqInfo;
    private List waitingReqInfo;
    private transient Object requestInfoLock;
    private String m_sQueueStatusOutput;
    private transient ItemDescriptor[][] m_idTransmittingReqTable;
    private transient ColumnDescriptor[] m_cdTransmittingReqTableStructure;
    private transient int[] m_iTransmittingReqTableSelection;
    private transient ItemDescriptor[][] m_idWaitingReqTable;
    private transient ColumnDescriptor[] m_cdWaitingReqTableStructure;
    private transient int[] m_iWaitingReqTableSelection;

    public RcsConnectionsBean() {
        Trace.trace(TRACE_MASKT, "<> RcsConnectionsBean()");
    }

    public void setQueueStatusOutput(String s) throws IllegalUserDataException {
        this.m_sQueueStatusOutput = s;
    }

    public String getQueueStatusOutput() {
        return this.m_sQueueStatusOutput;
    }

    public void setTransmittingReqTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iTransmittingReqTableSelection = selected;
    }

    public int[] getTransmittingReqTableSelection() {
        return this.m_iTransmittingReqTableSelection;
    }

    public void setTransmittingReqTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idTransmittingReqTable[index] = items;
    }

    public ItemDescriptor[] getTransmittingReqTableRowAt(int index) {
        return this.m_idTransmittingReqTable[index];
    }

    public int getTransmittingReqTableRowCount() {
        return this.m_idTransmittingReqTable.length;
    }

    public int getTransmittingReqTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getTransmittingReqTableRowStructure() {
        return this.m_cdTransmittingReqTableStructure;
    }

    public void setWaitingReqTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iWaitingReqTableSelection = selected;
    }

    public int[] getWaitingReqTableSelection() {
        return this.m_iWaitingReqTableSelection;
    }

    public void setWaitingReqTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idWaitingReqTable[index] = items;
    }

    public ItemDescriptor[] getWaitingReqTableRowAt(int index) {
        return this.m_idWaitingReqTable[index];
    }

    public int getWaitingReqTableRowCount() {
        return this.m_idWaitingReqTable.length;
    }

    public int getWaitingReqTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getWaitingReqTableRowStructure() {
        return this.m_cdWaitingReqTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> verifyChanges()");
        Trace.trace(TRACE_MASKT, "<- verifyChanges()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> load()");
        this.m_sQueueStatusOutput = "";
        this.m_idTransmittingReqTable = new ItemDescriptor[0][0];
        this.m_cdTransmittingReqTableStructure = new ColumnDescriptor[0];
        this.m_iTransmittingReqTableSelection = new int[0];
        this.m_idWaitingReqTable = new ItemDescriptor[0][0];
        this.m_cdWaitingReqTableStructure = new ColumnDescriptor[0];
        this.m_iWaitingReqTableSelection = new int[0];
        Trace.trace(TRACE_MASKT, "<- load()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> save()");
        Trace.trace(TRACE_MASKT, "<- save()");
    }

    public void setQueueEnabled(boolean value) {
        this.queueEnabled = value;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        this.requestInfoLock = new Object();
        this.activeReqInfo = new ArrayList();
        this.waitingReqInfo = new ArrayList();
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        PanelTaskletRequest request = new PanelTaskletRequest();
        request.setSource(this.getUniqueTaskletRequestId());
        request.setData("Source", "RcsConnectionsPanel");
        request.setData("Command", "UpdateQueueStatus");
        this.postTaskletRequest(request);
        request = new PanelTaskletRequest();
        request.setSource(this.getUniqueTaskletRequestId());
        request.setData("Source", "RcsConnectionsPanel");
        request.setData("Command", "UpdateRequestInfo");
        this.postTaskletRequest(request);
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelAction(TaskActionEvent event) {
        block31: {
            Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
            try {
                String element = event.getElementName();
                if (element.endsWith("PrioritizeItem")) {
                    ArrayList selectedReqs = new ArrayList();
                    Object object = this.requestInfoLock;
                    synchronized (object) {
                        for (int i = 0; i < this.m_iWaitingReqTableSelection.length; ++i) {
                            selectedReqs.add(this.waitingReqInfo.get(this.m_iWaitingReqTableSelection[i]));
                        }
                    }
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource(this.getUniqueTaskletRequestId());
                    request.setData("Source", "RcsConnectionsPanel");
                    request.setData("Command", "PrioritizeRequests");
                    request.setData("RequestInfo", selectedReqs);
                    this.postTaskletRequest(request);
                    break block31;
                }
                if (element.endsWith("CancelSelectedItem")) {
                    ArrayList selectedReqs = new ArrayList();
                    Object request = this.requestInfoLock;
                    synchronized (request) {
                        int i;
                        for (i = 0; i < this.m_iTransmittingReqTableSelection.length; ++i) {
                            selectedReqs.add(this.activeReqInfo.get(this.m_iTransmittingReqTableSelection[i]));
                        }
                        for (i = 0; i < this.m_iWaitingReqTableSelection.length; ++i) {
                            selectedReqs.add(this.waitingReqInfo.get(this.m_iWaitingReqTableSelection[i]));
                        }
                    }
                    request = new PanelTaskletRequest();
                    ((TaskletRequest)request).setSource(this.getUniqueTaskletRequestId());
                    ((RawRequest)request).setData("Source", "RcsConnectionsPanel");
                    ((RawRequest)request).setData("Command", "CancelRequests");
                    ((RawRequest)request).setData("RequestInfo", selectedReqs);
                    this.postTaskletRequest((PanelTaskletRequest)request);
                    break block31;
                }
                if (element.endsWith("CancelActiveItem")) {
                    ArrayList activeReqs;
                    Object request = this.requestInfoLock;
                    synchronized (request) {
                        activeReqs = new ArrayList(this.activeReqInfo);
                    }
                    request = new PanelTaskletRequest();
                    ((TaskletRequest)request).setSource(this.getUniqueTaskletRequestId());
                    ((RawRequest)request).setData("Source", "RcsConnectionsPanel");
                    ((RawRequest)request).setData("Command", "CancelRequests");
                    ((RawRequest)request).setData("RequestInfo", activeReqs);
                    this.postTaskletRequest((PanelTaskletRequest)request);
                    break block31;
                }
                if (element.endsWith("CancelWaitingItem")) {
                    ArrayList waitingReqs;
                    Object request = this.requestInfoLock;
                    synchronized (request) {
                        waitingReqs = new ArrayList(this.waitingReqInfo);
                    }
                    request = new PanelTaskletRequest();
                    ((TaskletRequest)request).setSource(this.getUniqueTaskletRequestId());
                    ((RawRequest)request).setData("Source", "RcsConnectionsPanel");
                    ((RawRequest)request).setData("Command", "CancelRequests");
                    ((RawRequest)request).setData("RequestInfo", waitingReqs);
                    this.postTaskletRequest((PanelTaskletRequest)request);
                    break block31;
                }
                if (element.endsWith("HoldTheQueueItem")) {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource(this.getUniqueTaskletRequestId());
                    request.setData("Source", "RcsConnectionsPanel");
                    request.setData("Command", "HoldQueue");
                    this.postTaskletRequest(request);
                } else if (element.endsWith("ReleaseTheQueueItem")) {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource(this.getUniqueTaskletRequestId());
                    request.setData("Source", "RcsConnectionsPanel");
                    request.setData("Command", "ReleaseQueue");
                    this.postTaskletRequest(request);
                } else if (element.endsWith("ExitItem") || element.equalsIgnoreCase("Cancel")) {
                    this.dispose();
                } else if (element.endsWith("RcsConnectionsPanel")) {
                    if (event.getActionCommand().equalsIgnoreCase("Cancel")) {
                        this.dispose();
                    } else {
                        Trace.trace(TRACE_MASKF, "Unknown action command");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown element");
                }
            }
            catch (RuntimeException rte) {
                new FrameworkLog(classLogInfo, 1941, rte).log();
                this.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object newData) {
        block10: {
            Trace.trace(TRACE_MASKT, "-> update");
            try {
                HashMap data = (HashMap)newData;
                String command = (String)data.get("Command");
                if (command == null) {
                    command = "";
                }
                Trace.trace(TRACE_MASKF, "command=" + command);
                if (command.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified command");
                    break block10;
                }
                if (command.equals("UpdateRequestInfo")) {
                    List[] requests = (List[])data.get("RequestInfo");
                    Object object = this.requestInfoLock;
                    synchronized (object) {
                        this.activeReqInfo = requests[0];
                        this.waitingReqInfo = requests[1];
                        this.updateDataBeanInfo(false);
                    }
                    this.updateUTMElements();
                    break block10;
                }
                if (command.equals("UpdateQueueStatus")) {
                    this.queueEnabled = (Boolean)data.get("QueueEnablement");
                    LocalizableText queueStatus = (LocalizableText)data.get("QueueStatus");
                    this.m_sQueueStatusOutput = queueStatus.toString();
                    this.updateUTMElements();
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown command");
                }
            }
            catch (RuntimeException rte) {
                new FrameworkLog(classLogInfo, 1941, rte).log();
                this.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- update");
    }

    private void updateDataBeanInfo(boolean initialUpdate) {
        Trace.trace(TRACE_MASKT, "-> updateDataBeanInfo(" + initialUpdate + ")");
        int numOfActive = this.activeReqInfo.size();
        Trace.trace(TRACE_MASKF, "activeReqs=" + numOfActive);
        this.m_idTransmittingReqTable = new ItemDescriptor[numOfActive][4];
        if (numOfActive > 0) {
            for (int i = 0; i < numOfActive; ++i) {
                RcsPathInfo pathInfo = (RcsPathInfo)this.activeReqInfo.get(i);
                this.m_idTransmittingReqTable[i][0] = new ItemDescriptor(null, pathInfo.getSystem());
                Calendar created = this.getCalendar(pathInfo.getCreateDate());
                this.m_idTransmittingReqTable[i][1] = new DateItemDescriptor(null, created);
                this.m_idTransmittingReqTable[i][2] = new TimeItemDescriptor(null, created);
                String desc = pathInfo.getDescription().toString();
                this.m_idTransmittingReqTable[i][3] = new ItemDescriptor(null, desc);
            }
            this.m_iTransmittingReqTableSelection = new int[0];
        } else {
            this.m_iTransmittingReqTableSelection = new int[0];
        }
        int numOfWaiting = this.waitingReqInfo.size();
        Trace.trace(TRACE_MASKF, "waitingReqs=" + numOfWaiting);
        this.m_idWaitingReqTable = new ItemDescriptor[numOfWaiting][5];
        if (numOfWaiting > 0) {
            for (int i = 0; i < numOfWaiting; ++i) {
                RcsPathInfo pathInfo = (RcsPathInfo)this.waitingReqInfo.get(i);
                this.m_idWaitingReqTable[i][0] = new ItemDescriptor(null, pathInfo.getSystem());
                String priority = pathInfo.getPriority().toString();
                this.m_idWaitingReqTable[i][1] = new ItemDescriptor(null, priority);
                Calendar created = this.getCalendar(pathInfo.getCreateDate());
                this.m_idWaitingReqTable[i][2] = new DateItemDescriptor(null, created);
                this.m_idWaitingReqTable[i][3] = new TimeItemDescriptor(null, created);
                String desc = pathInfo.getDescription().toString();
                this.m_idWaitingReqTable[i][4] = new ItemDescriptor(null, desc);
            }
            this.m_iWaitingReqTableSelection = new int[0];
        } else {
            this.m_iWaitingReqTableSelection = new int[0];
        }
        Trace.trace(TRACE_MASKT, "<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace(TRACE_MASKT, "-> updateUTMElements()");
        if (this.userTaskManager != null) {
            String prefix = this.getMountPrefix();
            String holdQueueItem = "OptionsMenu.HoldTheQueueItem";
            String releaseQueueItem = "OptionsMenu.ReleaseTheQueueItem";
            if (this.queueEnabled) {
                this.userTaskManager.setEnabled(prefix + holdQueueItem, true);
                this.userTaskManager.setEnabled(prefix + releaseQueueItem, false);
            } else {
                this.userTaskManager.setEnabled(prefix + holdQueueItem, false);
                this.userTaskManager.setEnabled(prefix + releaseQueueItem, true);
            }
            this.userTaskManager.refreshAllElements();
        }
        Trace.trace(TRACE_MASKT, "<- updateUTMElements()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUniqueTaskletRequestId() {
        RcsConnectionsBean rcsConnectionsBean = this;
        synchronized (rcsConnectionsBean) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.taskletRequestId);
            sb.append("-");
            sb.append(++this.taskletRequestNum);
            return sb.toString();
        }
    }

    private Calendar getCalendar(Date date) {
        Calendar calendar = null;
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            calendar = userContext != null ? Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale()) : Calendar.getInstance();
        }
        catch (Exception e) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        return calendar;
    }
}

